import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import it.eng.eremita.jpa.entity.Ruolo;
import it.eng.eremita.jpa.entity.Utente;
import it.eng.eremita.jpa.manager.Accessor;

@WebFilter(urlPatterns="*")
public class FederaFilter implements Filter{
	
	public final static String FEDERA_NOME = "nome";
    public final static String FEDERA_COGNOME = "cognome";
    public final static String FEDERA_CF = "codicefiscale";
    public final static String FEDERA_EMAIL = "emailaddress";
    public final static String FEDERA_PASSWORD_LEVEL = "policylevel";
    public final static String FEDERA_TRUST_LEVEL = "trustlevel";
    
    private boolean filtroAttivo = true;
    private String ambiente = null;

	@Override
	public void destroy() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		
		HttpServletResponse httpResponse = (HttpServletResponse) response;
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		String uri = httpRequest.getRequestURI();
		
		httpResponse.addHeader("Access-Control-Allow-Origin", "http://localhost:3000");
		httpResponse.addHeader("Access-Control-Allow-Credentials", "true");
		httpResponse.addHeader("Access-Control-Allow-Headers", "content-type");
		//HttpSession session= httpRequest.getSession(true);
		
		System.out.println("FEDERA FILTER "+httpRequest.getRequestURI());
		//System.out.println("SESSION "+session);
		
		
		
		if(ambiente==null) {
			ambiente = Accessor.getAmbiente();
			//System.out.println("Ambiente: "+ambiente);
			if ("SVILUPPO".equals(ambiente)) filtroAttivo = false;
		}
		
		
		String cf = httpRequest.getHeader(FEDERA_CF);
		String passwordLevel = httpRequest.getHeader(FEDERA_TRUST_LEVEL);
		
		
		if (cf==null) {
			if (filtroAttivo) {
				httpResponse.setStatus(403);
				return;
			} else cf = "FVNGPR81P12G467R"; //in ambiente di sviluppo usa cf di default
		}
		
		
		if (Accessor.getEremitaManager().isUtenteEsistente(cf)) {
			//Accessor.setUtenteAttuale(httpRequest,cf);
			chain.doFilter(request, response);
			return;
		} else {
			if (Accessor.utentiOspiti()) {
				Utente u = new Utente();
				Ruolo r = Accessor.getEremitaManager().getById(Ruolo.class, "RUOLO_OSPITE");
				u.setId(cf);
				u.setCognome(httpRequest.getHeader(FEDERA_COGNOME));
				u.setNome(httpRequest.getHeader(FEDERA_NOME));
				u.setEmail(httpRequest.getHeader(FEDERA_EMAIL));
				u.setRuolo(r);
				Accessor.getEremitaManager().forceUpdateAndCommit(u);
				
			
			} else {
				httpResponse.setStatus(403);
				return;
			}
		}
		
		httpResponse.setStatus(403);
	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {
		// TODO Auto-generated method stub
		
	}

}
